using UnityEngine;
using System.Collections;
 
public class s_ShowFPS : MonoBehaviour 
{
 
	// Thanks unity wiki! http://wiki.unity3d.com/index.php?title=FramesPerSecond
	
	/*
	Attach this to a GUIText to make a frames/second indicator.
	
	It calculates frames/second over each updateInterval,
	so the display does not keep changing wildly.
	
	It is also fairly accurate at very low FPS counts (<10).
	We do this not by simply counting frames per interval, but
	by accumulating FPS for each frame. This way we end up with
	correct overall FPS even if the interval renders something like
	5.5 frames.
	*/
 
	public  float mUpdateInterval = 0.5f;
	 
	private float mAccum   = 0; // FPS accumulated over the interval
	private int   mFrames  = 0; // Frames drawn over the interval
	private float mTimeleft; 	// Left time for current interval
	 
	void Start()
	{
	    if(!guiText)
	    {
	        Debug.Log("UtilityFramesPerSecond needs a GUIText component!");
	        enabled = false;
	        return;
	    }
		
	    mTimeleft = mUpdateInterval;  
	}
	 
	void Update()
	{
	    mTimeleft -= Time.deltaTime;
	    mAccum += Time.timeScale/Time.deltaTime;
	    ++mFrames;
	 
	    // Interval ended - update GUI text and start new interval
	    if(mTimeleft <= 0.0)
	    {
		     // display two fractional digits (f2 format)
			float fps = mAccum/mFrames;
			string format = System.String.Format("{0:F2} FPS",fps);
			guiText.text = format;
	 
	        mTimeleft = mUpdateInterval;
	        mAccum = 0.0f;
	        mFrames = 0;
	    }
	}
}